ORCA/M Asm65816 2.1.0

0001 83E5              ***          Copyright Apple Computer, Inc. 1985-1989        ***
0002 83E5              ***          All Rights Reserved                             ***
0003 83E5              ********************************************************
0004 83E5              *
0005 83E5              * Fsynth.irq: This routine will service interrupts for the DOC free
0006 83E5              *             form synthesizer.
0007 83E5              *
0008 83E5              *     Import:
0009 83E5              *             (E100CC) = oscillator number generating irq.
0010 83E5              *
0011 83E5              *     Export: A, X, Y, D = same as entry
0012 83E5              *
0013 83E5              ********************************************************
0014 83E5              ;
0015 83E5              ;
0016 83E5              ;
0017 83E5
0018 83E5              ***	include 'all.macros'	;removed 17-Sep-90 DAL
0019 83E5                       include 'm16.util2' 
0020 83E5                       include 'Snd.Equ.aii' 
0021 83E5
0022 83E5                       import gentable 
0023 83E5                       import gcb_xlate 
0024 83E5                       import serve_gen 
0025 83E5
0026 83E5                       LONGA OFF                      ;
0027 83E5                       LONGI OFF                      ;
0028 83E5
0029 83E5                       export fsynth_irq 
0030 83E5              Fsynth_irq proc                         ;
0031 83E5 0B                    phd                            ; save direct register
0032 83E6 AF B8 1D E1           lda   >sram_base+wap_addr+1    ; point to our work area
0033 83EA 48                    pha                            ;
0034 83EB AF B7 1D E1           lda   >sram_base+wap_addr      ;
0035 83EF 48                    pha                            ;
0036 83F0 2B                    pld                            ;
0037 83F1 AF CC 00 E1           lda   >osc_no_irq              ;
0038 83F5              nxt_osc_irq                             ;
0039 83F5 E2 30                 sep   #$30                     ; native
0040 83F7 18                    clc                            ; no carry please
0041 83F8 6A                    ror   A                        ; put it in workable form
0042 83F9 29 1F                 and   #$1F                     ; 32 oscillators
0043 83FB 85 F6                 sta   osc_num_temp             ; save the oscillator number
0044 83FD C9 1E                 cmp   #$1E                     ; check for oscillator 30-31
0045 83FF 90 06                 bcc   not_apple                ; not apple reserved
0046 8401 22 34 87 02           jsl   apple_snd                ; will return through CLC, RTL
0047 8405 80 10                 bra   chk_nxt_osc              ; check rest of oscillators
0048 8407              not_apple                               ;
0049 8407 AA                    tax                            ; save the oscillator number
0050 8408 BF DA 85 02           lda   >gentable,x              ; get generator number
0051 840C AA                    tax                            ;
0052 840D BF FA 85 02           lda   >gcb_xlate,x             ; get the start addr of the gcb
0053 8411 AA                    tax                            ;
0054 8412 08                    php                            ; save status reg
0055 8413 20 38 87              jsr   serve_gen                ;
0056 8416 28                    plp                            ; restore status
0057 8417              chk_nxt_osc                             ;
0058 8417 E2 20                 sep   #$20                     ;
0059 8419 AF CA 00 E1           lda   >irq_volume              ; select DOC no auto incr
0060 841D 8F 3C C0 E1           sta   gstatreg                 ;
0061 8421 A9 E0                 lda   #eoir                    ; read DOC irq register
0062 8423 8F 3E C0 E1           sta   gadrl                    ;
0063 8427 AF 3D C0 E1           lda   gdatreg                  ; read the DOC irq register
0064 842B AF 3D C0 E1           lda   gdatreg                  ;
0065 842F 10 C4                 bpl   nxt_osc_irq              ; got a live one!!
0066 8431              exit_firq                               ;
0067 8431 2B                    pld                            ; restore direct register
0068 8432 18                    clc                            ; according to Peter
0069 8433 6B                    rtl                            ;
0070 8434              ;
0071 8434              ;
0072 8434              apple_snd                               ;
0073 8434 5C 48 01 E1           jmp   >asnd_vect               ; go to the Apple reserved vector
0074 8438
0075 8438
0076 8438                       endp 
0077 8438                       end   
